/**
 * @fileOverview
 * @author luangong
 * @version 1.0
 */
$(function() {
    menu.init();
});

var menu = {};

/**
 * 从 URL 的 GET 参数中获取菜单 ID
 */
menu.getId = function() {
    return parseInt(qqbrowser.js.logic.utils.parseUrl().id, 10);
};

/**
 * 初始化菜单
 */
menu.init = function() {
    var menuId = menu.getId();
    qqbrowser.skin.menu.init(menuId, function(retval) {
        var menuData = {};
        if (retval) {
            menuData = JSON.parse(retval, function(key, value) {
                return typeof(value) == 'string' ? unescape(value) : value;
            });
        }
        menu.build(menuData);
    });
};

menu.params = null;

/**
 * 构造菜单
 */
menu.build = function(data) {
    // 设置帐号信息
    qqbrowser.account.getCurrent(function(accountData) {
        var userInfo = eval('(' + accountData + ')')[0];

//      $('#avatar').attr('src', userInfo.strFacePath);
        $('#nickname').text(unescape(userInfo.strNickName));
        $('#account').text('(' + unescape(userInfo.nUin) + ')');
    });

    var menuData = data[1];
    menu.params = data[2];
    var menuId = menu.getId();
    var menuElement = $('#after-menu-content');
    var menuHTML = '';

    // 构造菜单
    for (var i = 0; i < menuData.length; i++) {
        var menuItem = menuData[i];
        var menuItemName = unescape(menuItem.name);

        // id: 每一菜单项的id
        // type：类型
        // enabled: 是否激活
        // checked: 是否选定
        // name: 名称
        // subMenuId: 子菜单id
        // icon: 图标

        // 分隔符的处理
        if (menuItem.type == 5) {
            menuHTML += '<li class="hr"></li>';
            continue;
        }

        var menuItemId = JSON.stringify(menuItem.id);
        var liStyle = menuItem.checked == 1 ? ' class="selected"' : '';
      //  alert(menuItemId);
        var liOnclick = ' onclick=\'menu.click(' + menuId + ',' + menuItemId + ')\'';

        // 父文件夹处理
/*      if (menuItem.subMenuId) {
            liStyle = ' class="parent" submenuid="' + menuItem.subMenuId + '"';
        } */

        // 状态
        if (!menuItem.enabled)
            liStyle = ' class="disabled"';

        menuHTML += 
            '<li' + liStyle + liOnclick + '>' +
                menuItemName +
            '</li>';    
    }
    menuElement.html(menuHTML);
    var menuSize = qqbrowser.js.logic.viewManager.getSize('after-menu-layer');
    qqbrowser.skin.menu.show(menuId, menuSize.width, menuSize.height);
};

menu.click = function(menuId, menuItemId) {
    /*if(menuItemId.id === 4){
        alert("in");
        //数据上报切换帐号选项
        qqbrowser.extension.builtin.statistics(STATIS_CMD_NAVBAR_BTN_LAST_CLOSE_PAGE_LIST_CLICKED);

    }*/
    qqbrowser.skin.menu.click(menuId, menuItemId, menu.params);
};
